<?php

namespace App\Http\Services;

use App\Cliente;
use App\ImagemCliente;
use App\OrdemCliente;
use Illuminate\Http\Request;

class ClienteService{

    public function store($request) {

        $dados = $request->all();
        $cliente = Cliente::create($dados);

        //Adicionar Imagens
        $imagens = $request->file('imagens');
        if($imagens != null){
            foreach($imagens as $imagem){
                $nome = time().'.'.$imagem->getClientOriginalName().'.'.$imagem->getClientOriginalExtension();
                $destino = public_path('img/clientes');
                $imagem->move($destino, $nome);
                $imagem = ImagemCliente::create([
                    'cliente_id' => $cliente->id,
                    'path' => 'img\clientes/'.$nome
                ]);
                $cliente->hasMany($imagem);
            }
        }   
    }  


    public function update($request, $cliente){
    
        $dados = $request->all();
        $cliente = Cliente::find($cliente->id);
        $cliente->fill($dados)->save();

        //Remover Imagens
        $ids = $request->get('imagensRemover');
        if($request->get('imagensRemover') != null){
            $cliente->imagens()->whereIn('id', $ids)->delete();
        }

        //Adicionar Imagens
        $imagens = $request->file('imagens');
        if($imagens != null){
            foreach($imagens as $imagem){

                $nome = time().'.'.$imagem->getClientOriginalName().'.'.$imagem->getClientOriginalExtension();
                $destino = public_path('img/clientes');
                $imagem->move($destino, $nome);
                $imagem = ImagemCliente::create([
                    'cliente_id' => $cliente->id,
                    'path' => 'img\clientes/'.$nome
                ]);
                $cliente->hasMany($imagem);
            }
        }
    }
    
    public function ordem(){
        $valores = Cliente::all();
        $ordemAtual = json_decode(OrdemCliente::find(1)->getAttribute('ordem'), true);
        $count = count($valores);
        $clientes = array();
        foreach ($valores as $valor) {
            $clientes[$valor->getAttribute('id')] = $valor->getAttribute('nome');
        }
        return array($count, $clientes, $ordemAtual);
    }
}
