
@extends('adm.template.template')

@section('conteudo')

    <div class="table-responsive">
        <table class="table table-bordered" id="listagem">
            <thead>
                <tr style="background-color: #f9f9f9">
                    <td>Login</td>
                    <td>Email</td>
                    <td>Data de Criação</td>
                    <td>Última Atualização</td>
                    <td class="text-center" style="width: 5%;">Editar</td>
                    <td class="text-center" style="width: 5%;">Excluir</td>
                </tr>
            </thead>
            <tbody>
            @foreach($lista as $user)
                <tr>
                    <td>{{ $user->name }}</td>
                    <td>{{ $user->email }}</td>
                    <td>
                        {{ date_create_from_format('Y-m-d H:i:s', $user->created_at)->format('d/m/Y') }}
                    </td>
                    <td>
                        {{ date_create_from_format('Y-m-d H:i:s', $user->updated_at)->format('d/m/Y à\s H:i:s') }}
                    </td>
                    <td class="text-center">
                        <a href="{{ route('user.edit', $user->id) }}">
                            <span class="fa fa-pencil"></span>
                        </a>
                    </td>
                    <td class="text-center">
                        @if($user->email != 'admin@admin.com')
                            {!! Form::open(['route' => ['user.destroy', $user->id], 'method' => 'DELETE']) !!}
                                {{ Form::button('<span class="fa fa-trash"></span>', 
                                    ['type' => 'submit', 'style' => 'color:red', ] )  
                                }}                        
                            {!! Form::close() !!}
                        @endif
                    </td>
                </tr>
            @endforeach
            </tbody>
        </table>
    </div>

    {!! Form::open(['route' => 'user.store', 'method' => 'post', 'id' => 'criar']) !!}
        <label style="margin-top: 30px;">
            <strong>Novo Usuário <span class="fa fa-plus"></span></strong>
        </label>
        <div class="row">
            <div class="form-group col-md-12">
                {!! Form::text('name', null, ['placeholder'=>'Nome', 'class' => 'form-control','maxlength' => 15]) !!}
            </div>
        </div>
        <div class="row">
            <div class="form-group col-md-12">
                {!! Form::email('email', null,  ['placeholder'=>'Email', 'class' => 'form-control']) !!}
            </div>
        </div>
        <div class="row">
            <div class="form-group col-md-12">
                {!! Form::password('password', ['placeholder'=>'Senha', 'class' => 'form-control', 'maxlength' => 8]) !!}
            </div>
        </div>
        <div class="row">
            <div class="form-group col-md-12">
                {!! Form::submit('Cadastrar', ['class' => 'btn btn-primary pull-right']) !!}
            </div>
        </div>
    {!! Form::close() !!}

@endsection

@section('js')
    <script type="text/javascript" src="{{ asset('js/adm/user.js') }}"></script>
@endsection